% Shottky nanotransistor
% first calculated base electrode with nanocontact
% second calculates just conector to nanocontact
% result  2 files: VZ-Con_Tr  VZ_Mag_Tr
% VZ_Mag_TR  is Shotkey contact
%VZ_Con_Tr cthe contact to Shottky
% also old calculation in lower part

clear all

k=0.8;   %points per nm


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%make nanomagnet with base for nanotransistor
% will generate two files
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


    %%%%%%%at first make  ellips to cover
   %%%%%%%at first make  ellips to cover
    el_sizeNano=70; % in nm nanocontact size
    el_size=40; % not used    in nm cover size problem  
    el_ratio=1/1.4;  % usualy 1.4
    el_contact=[60 1500]; %%% Y length of contact electrode nm, X length should be less than ellipse!!!! width should be less or equal to ellips size
    el_pad=[1000 800];  % electrode pad 
    base_gap=140; %gap to base
    contact_gap=20;  % 
    metal_gap=10; % it is how mwtal contact smaller of original
    base_thickness=100;
    upEllipSh=20;
    %base_above=500; % base above center of contact; should be biger than el_contact
     base_contact=[100 1000];
    base_pad=[1000 800];  % base pad Y coordinate need to be calculated
    %!!!!!! pad Y should be used so that ellipse be at center 
    base_pad(2)=el_contact(2)+el_pad(2);
    
    myAngle=45;  % opening angle usually 45 deg
     EllipseInLineWidth=8; %nm
     EllipseGap=0; %nm
    PadsInLineWidth=8; %nm
    ContactInLineWidth=8; %nm
    BaseInnerGap=30;
    BaseOutGap=34;
    ContactGap=25;
    ContactGapPos=20;  %for positive resist contact
    

    
    ContactEllipseCenter='yes'; % 'non'  'yes'
     DoEllipseCenter='non'; % 'yes' 'non'
     DecompElectr='non'
    
    MyNameAll=['Tr' num2str(el_sizeNano) 'F1'];
    MyName1=['Mag_' MyNameAll];
    MyName2=['Con_' MyNameAll];

        DoDecompose='non';
    DecomExpWidthEl=3.75;  % nm A3 res 3.75
    DecomposRatioEl=3;  % how much average exp reduce A3 neg 4.45  pos 2.15
    DecomposNonWidthEl=DecomExpWidthEl*(DecomposRatioEl-1) ; % just monitor
    %for pads
        DecomExpWidth=3.75*4;  % nm A3 res 3.75
    DecomposRatio=4.6;  % how much average exp reduce A3 neg 4.45  pos 2.15
    DecomposNonWidth=DecomExpWidth*(DecomposRatioEl-1);  % just monitor

    global AngleToTurn
    AngleToTurn=-90;
    
  UpMoveBase=30; %nm
%%%%%%%%%%%%%%%%%%%%%%%%new
%%%%%%%%%%%%%%%%%%%%%%%%%
  

%%%%%%%%%%%%%
    % hole  in all 
    Ellpse_open=el_sizeNano*0.5;
    %generate semi elipse size
    Selipse_size=el_sizeNano;
    %myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180
        fi=myAngle:1:(360-myAngle);
    for j=1:length(fi)
    MyMag(j,2)=0.5*el_sizeNano*cos(fi(j)*pi/180)/el_ratio;
    MyMag(j,1)=0.5*el_sizeNano*sin(fi(j)*pi/180)*el_ratio;
    MyMag0(j,2)=MyMag(j,2);
    MyMag0(j,1)=MyMag(j,1);
     dydx=MyMag(j,1)/MyMag(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    EllipNorm(j,1)=dydx/Norm;EllipNorm(j,2)=1/Norm;
    if fi(j)>90&fi(j)<=270
      EllipNorm(j,2)=-EllipNorm(j,2);
      EllipNorm(j,1)=-EllipNorm(j,1);
  end
    end
    %figure(1);plot(EllipNorm(:,1),EllipNorm(:,2));return
%%%%%

    MyStep=el_sizeNano-EllipseInLineWidth*2;
    myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180;;
    for j=1:length(fi)
    MyInLine(j,2)=MyMag0(j,2)-EllipNorm(j,2)*EllipseInLineWidth;
    MyInLine(j,1)=MyMag0(j,1)-EllipNorm(j,1)*EllipseInLineWidth;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    DownInLine(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];DownInLine(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine;
    %figure(1); clf;hold on;plotJ01(DownInLine); ;hold off; return
    %%%%%%%%%%%%%

    %generate semi elipse size
    Selipse_size=el_sizeNano;
    myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180;;
        fi1=-myAngle:1:myAngle;
    for j=1:length(fi1)
    MyMag(j,2)=0.5*Selipse_size*cos(fi1(j)*pi/180)/el_ratio;
    MyMag(j,1)=0.5*Selipse_size*sin(fi1(j)*pi/180)*el_ratio;
         dydx=MyMag(j,1)/MyMag(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    NormTEMP(j,1)=dydx/Norm;NormTEMP(j,2)=1/Norm;

    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%
    % hole  in all 
    Ellpse_open=el_sizeNano;
    %generate semi elipse size
    Selipse_size=el_sizeNano-EllipseInLineWidth*2;
    myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180;;

    for j=1:length(fi1)
    MyInLine(j,2)=MyMag(j,2)-NormTEMP(j,2)*EllipseInLineWidth;
    MyInLine(j,1)=MyMag(j,1)-NormTEMP(j,1)*EllipseInLineWidth;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    UpInLine(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];UpInLine(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine;

       
            %%%%%%%generate inner of ellipse
            % for our ellipse x^2/ellip+y^2*ellip=1  dy/dx=-x/y*ellip^2;
            % (1,dy/dx) touch; norm (-dy/dx,1)=(x/y*ellipt^2,1) or -(x/y*ellipt^2,1)
    fi2=2:2:358;
    for j=1:length(fi2)
    InnerCir(j,1)=el_sizeNano*0.5*cos(fi2(j)*pi/180)*el_ratio;
    InnerCir(j,2)=el_sizeNano*0.5*sin(fi2(j)*pi/180)/el_ratio;
    dydx=InnerCir(j,1)/InnerCir(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    UniV(1)=dydx/Norm;UniV(2)=1/Norm;
    if fi2(j)>180
      UniV=-UniV;
  end
    InnerC(j,1)=InnerCir(j,1)-(EllipseInLineWidth+EllipseGap)*UniV(1);
    InnerC(j,2)=InnerCir(j,2)-(EllipseInLineWidth+EllipseGap)*UniV(2);
    % for metal 
    MetalC(j,1)=InnerCir(j,1)-metal_gap*UniV(1);
    MetalC(j,2)=InnerCir(j,2)-metal_gap*UniV(2);
    %  metal inline in
    InMetalC(j,1)=MetalC(j,1)-EllipseInLineWidth*UniV(1);
    InMetalC(j,2)=MetalC(j,2)-EllipseInLineWidth*UniV(2);
         % metal area
    AreaMetal(j,1)=InMetalC(j,1)-EllipseGap*UniV(1);
    AreaMetal(j,2)=InMetalC(j,2)-EllipseGap*UniV(2);    
     
    
    % normal
    InnerCirN(j,1)=UniV(1);
    InnerCirN(j,2)=UniV(2);
    
    end
    
    if DoEllipseCenter=='yes'
         if  DoDecompose=='yes'
         MyCell=DecomposCircle(InnerC,InnerCirN, DecomExpWidthEl,DecomposRatioEl,1);clear InnerC, InnerC=MyCell; clear MyCell;
     if DecompElectr=='yes';MyCell=DecomposCircle(AreaMetal,InnerCirN, DecomExpWidthEl,DecomposRatioEl,1);clear AreaMetal, AreaMetal=MyCell; clear MyCell;end;
     end
 end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      InLineMetal=[MetalC; flipud(InMetalC)];


    %figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);;hold off; return
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%base
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%inner inline

    ElShift=base_gap;
    for j=1:length(fi)
    MyMag(j,2)=MyMag0(j,2)+EllipNorm(j,2)*ElShift;
    MyMag(j,1)=MyMag0(j,1)+EllipNorm(j,1)*ElShift;
    end
%%%
       ElShift=base_gap+EllipseInLineWidth; 
    for j=1:length(fi)
    MyInLine(j,2)=MyMag0(j,2)+EllipNorm(j,2)*ElShift;
    MyInLine(j,1)=MyMag0(j,1)+EllipNorm(j,1)*ElShift;
    end
    BaseInnerInLine(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];BaseInnerInLine(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine;
    %figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);plotJ01(BaseInnerInLine);;hold off; return
 %%%%%%%%%%%%%%% base   main
        ElShift=ElShift+BaseInnerGap;
    for j=1:length(fi)
    MyMag(j,2)=MyMag0(j,2)+EllipNorm(j,2)*ElShift;
    MyMag(j,1)=MyMag0(j,1)+EllipNorm(j,1)*ElShift;
    end
%%%
       ElShift=ElShift+base_thickness-PadsInLineWidth-BaseOutGap; 
    for j=1:length(fi)
    MyInLine(j,2)=MyMag0(j,2)+EllipNorm(j,2)*ElShift;
    MyInLine(j,1)=MyMag0(j,1)+EllipNorm(j,1)*ElShift;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   if  DoDecompose=='yes'
       BaseMain=DecomposSemi(MyMag,base_thickness-PadsInLineWidth-BaseOutGap,EllipNorm, DecomExpWidthEl,DecomposRatioEl,1);
   else
         BaseMain(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];BaseMain(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];    
         end
    
    clear MyMag; clear MyInLine;
    

    
    
   %%%%%%%%%%%%%%% base   outer inline
        ElShift=ElShift+BaseOutGap;
    for j=1:length(fi)
    MyMag(j,2)=MyMag0(j,2)+EllipNorm(j,2)*ElShift;
    MyMag(j,1)=MyMag0(j,1)+EllipNorm(j,1)*ElShift;
    end
%%%
       ElShift=ElShift+PadsInLineWidth; 
    for j=1:length(fi)
    MyInLine(j,2)=MyMag0(j,2)+EllipNorm(j,2)*ElShift;
    MyInLine(j,1)=MyMag0(j,1)+EllipNorm(j,1)*ElShift;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    BaseOutInLine(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];BaseOutInLine(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine;  
    
    
    %figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);
    %plotJ01(BaseMain); plotJ01(BaseOutInLine);plotJ01(BaseInnerInLine);;hold off; return

    %%%%%%%%%%%% generate thin contact
   
     BaseContact=[base_contact(1)/2 0;-base_contact(1)/2 0;-base_contact(1)/2 -base_contact(2);base_contact(1)/2 -base_contact(2)];
     BaseContact(:,2)=BaseContact(:,2)-(ElShift+el_sizeNano/2)-2*EllipseInLineWidth;
     [BaseContactConLine, BaseContactArea]=InLineObject(BaseContact,EllipseInLineWidth);
         [deleteMe, tmp123]=InLineObject(BaseContactArea,ContactGap);
     clear BaseContactArea; BaseContactArea=tmp123; clear deleteMe; clear tmp123;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%base pad
BasePad=[BaseContact(1,1) 0;BaseContact(2,1) 0; -base_pad(1)/2 -base_pad(2);base_pad(1)/2 -base_pad(2)];
    BasePad(:,2)=BasePad(:,2)+BaseContact(4,2);
    % adjust sizes within 5 um
BasePad(4,2)=-2450;BasePad(3,2)=-2450;
    [BasePadLine, BasePadArea]=InLineObject(BasePad,PadsInLineWidth);
             [deleteMe, tmp123]=InLineObject(BasePadArea,ContactGap);
     clear BasePadArea; BasePadArea=tmp123; clear deleteMe; clear tmp123;
    %%%%figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);
    %%%%plotJ01(BaseMain); plotJ01(BaseOutInLine);plotJ01(BaseInnerInLine);plotJ01(BaseContactConLine);
    %%%%plotJ01(BaseContactArea);plotJ01(BasePadLine);plotJ01(BasePadLine);;hold off; return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%top contact
%%% MetalC used for contact
%%%%%%%%%%%% generate thin contact
    widining=el_sizeNano+base_gap+base_thickness;
    UpBaseContact=[-el_contact(1)/2 widining; -el_contact(1)/2 0; el_contact(1)/2 0;el_contact(1)/2 widining; 2*el_contact(1) el_contact(2);-2*el_contact(1) el_contact(2)];
     %UpBaseContact=[-el_sizeNano/3 0;el_sizeNano/3 0;el_sizeNano/3 base_contact(2);-el_sizeNano/3 base_contact(2)];
     UpBaseContact(:,2)=UpBaseContact(:,2)+MetalC(round(length(fi2)/4),2);%(el_sizeNano-metal_gap)/1.5;
     [UpBaseContactLine, UpBaseContactArea]=InLineObject(UpBaseContact,EllipseInLineWidth);
     
     [deleteMe, tmp123]=InLineObject(flipud(UpBaseContactArea),ContactGapPos);
     clear UpBaseContactArea; UpBaseContactArea=flipud(tmp123); clear deleteMe; clear tmp123;
     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%base pad
UpBasePad=[UpBaseContact(5,1) 0;UpBaseContact(6,1) 0; -base_pad(1)/2 base_pad(2);base_pad(1)/2 base_pad(2)];
    UpBasePad(:,2)=UpBasePad(:,2)+UpBaseContact(5,2);
    UpBasePad(3,2)=2490;UpBasePad(4,2)=2490;
    [UpBasePadLine, UpBasePadArea]=InLineObject(UpBasePad,PadsInLineWidth);
    [deleteMe, tmp123]=InLineObject(UpBasePadArea,ContactGapPos);
     clear UpBasePadArea; UpBasePadArea=tmp123; clear deleteMe; clear tmp123;
%%%
% adjust sizes within 5 um
UpBasePad(4,2)=2450;UpBasePad(3,2)=2450;
    clear MyMag; clear MyInLine;  
    
    
       figure(3); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);
    plotJ01(BaseMain); plotJ01(BaseOutInLine);plotJ01(BaseInnerInLine);plotJ01(BaseContactConLine);
    plotJ01(BaseContactArea);plotJ01(BasePadLine);
     plotJ01(MetalC);plotJ01(UpBaseContactLine);plotJ01(UpBaseContactArea);; plotJ01(UpBasePadArea);plotJ01(UpBasePadLine);hold off;
     if DoEllipseCenter=='yes';plotJ01(InnerC);end;
     % devide contact
     UpBaseContactAreaS=[UpBaseContactArea(2:4,:); UpBaseContactArea(1,:)];
     UpBaseContactAreaB=[UpBaseContactArea(1,:);UpBaseContactArea(4:6,:)];
     
     
     %%%%%%  moving base up
   
     BaseMain(:,2)=BaseMain(:,2)- UpMoveBase;BaseOutInLine(:,2)=BaseOutInLine(:,2)- UpMoveBase;
     BaseInnerInLine(:,2)=BaseInnerInLine(:,2)- UpMoveBase;BaseContactConLine(:,2)=BaseContactConLine(:,2)- UpMoveBase;
     BaseContactArea(:,2)=BaseContactArea(:,2)- UpMoveBase;BasePadLine(:,2)=BasePadLine(:,2)- UpMoveBase;
     %UpBaseContactLine(:,2)=UpBaseContactLine(:,2)- UpMoveBase;UpBaseContactArea(:,2)=UpBaseContactArea(:,2)- UpMoveBase;
     BasePadArea(:,2)=BasePadArea(:,2)- UpMoveBase;
     
     
     if  DoDecompose=='yes'
         MyCell=Decompos(BasePadArea, DecomExpWidth,DecomposRatio,1);clear BasePadArea; BasePadArea=MyCell; clear MyCell;

         MyCell=Decompos(BaseContactArea, DecomExpWidth,DecomposRatio,1);clear BaseContactArea; BaseContactArea=MyCell; clear MyCell;
         MyCell=Decompos(UpBaseContactAreaS, DecomExpWidthEl,DecomposRatioEl,1);clear UpBaseContactAreaS; UpBaseContactAreaS=MyCell; clear MyCell;
         MyCell=Decompos(UpBaseContactAreaB, DecomExpWidth,DecomposRatio,1);clear UpBaseContactAreaB; UpBaseContactAreaB=MyCell; clear MyCell;
         MyCell=Decompos(UpBasePadArea, DecomExpWidth,DecomposRatio,1);clear UpBasePadArea; UpBasePadArea=MyCell; clear MyCell;
         %semi
         %         MyCell=Decompos(BaseMain, DecomExpWidth,DecomposRatio,1);;clear BaseMain; BaseMain=MyCell; clear MyCell;
         
     end
     

     
     MyShift=[2500 2500];MyShift2=[2500 2500];
     DownInLine1=ToJ01(DownInLine,MyShift); UpInLine1=ToJ01(UpInLine,MyShift);
     BaseOutInLine1=ToJ01(BaseOutInLine,MyShift);BaseInnerInLine1=ToJ01(BaseInnerInLine,MyShift);
    BaseContactConLine1=ToJ01(BaseContactConLine,MyShift);
    
    BasePadLine1=ToJ01(BasePadLine,MyShift);
     UpBaseContactLine2=ToJ01(UpBaseContactLine,MyShift2);UpBasePadLine2=ToJ01(UpBasePadLine,MyShift2);
     
     MetalC1=ToJ01(MetalC,MyShift2);
     
     InnerC1=ToJ01(InnerC,MyShift);
          InLineMetal1=ToJ01(InLineMetal,MyShift);AreaMetal1=ToJ01(AreaMetal,MyShift);
    
     BaseMain1=ToJ01(BaseMain,MyShift);BasePadArea1=ToJ01(BasePadArea,MyShift);
     BaseContactArea1=ToJ01(BaseContactArea,MyShift); 
     UpBaseContactAreaS2=ToJ01(UpBaseContactAreaS,MyShift2);UpBaseContactAreaB2=ToJ01(UpBaseContactAreaB,MyShift2);UpBasePadArea2=ToJ01(UpBasePadArea,MyShift2);

     
          global plotJ01UseFill
     plotJ01UseFill=1;   % use plot with fill
     global plotJ01Color
         figure(1); clf;hold on;
         plotJ01Color='y'; %area

           plotJ01(BasePadArea1);plotJ01(BaseContactArea1);;plotJ01(BaseMain1);
         
         if DoEllipseCenter=='yes';plotJ01(InnerC1);end;
         plotJ01Color='r'; %extra line
          plotJ01(UpInLine1);plotJ01(BaseOutInLine1); plotJ01(BaseContactConLine1);plotJ01(BasePadLine1);
         plotJ01Color='g'; %inner line
         plotJ01(DownInLine1);plotJ01(BaseInnerInLine1);
    
    grid on; hold off;plotJ01UseFill=0;   % use plot without fill
    
    plotJ01UseFill=1;   % use plot with fill
     figure(2); clf;hold on;
     plotJ01Color='y'; %area

     %plotJ01(MetalC1);
     if ContactEllipseCenter=='yes'
     plotJ01(AreaMetal1);
 end
     plotJ01(UpBaseContactAreaS2);plotJ01(UpBaseContactAreaB2);plotJ01(UpBasePadArea2);

     plotJ01Color='r'; %inline
     plotJ01(UpBaseContactLine2);plotJ01(UpBasePadLine2); 
     plotJ01(InLineMetal1);
     grid on; hold off;plotJ01UseFill=0;   % use plot without fill
     
     %%%%%%%%%%%%%%%%%%%saving
           MyNameS1=['ID/VZ_' MyName1 '\n'];
    MyNameS2=['ID/VZ_' MyName2 '\n'];
    myFileName1=['VZ_' MyName1 '.j01'];
    myFileName2=['VZ_' MyName2 '.j01'];
    
%      MySizes=findObjectSizes(UpBaseContactArea2);  % not all
    
    fid = fopen(myFileName1,'w');
 %    PrintSizesToFile;
     fprintf(fid,['*Shottky transistor  for ' num2str(el_sizeNano) ' nm  nanocontact ratio ' num2str(el_ratio) ' \n']);
     fprintf(fid,['* following by metal contact ' myFileName2 '  \n']);
     fprintf(fid,['*base gap ' num2str(base_gap)  ' \n']);
     fprintf(fid,['* three explos 1 all area, 2 extrnal inline  3 inner inline   \n']);
     fprintf(fid,['*base thickness  ' num2str(base_thickness)  ' \n']);
     fprintf(fid,['*inline ellipse ' num2str(EllipseInLineWidth) ' nm pads ' num2str(PadsInLineWidth) ' nm contact' num2str(ContactInLineWidth) ' nm \n']);
     fprintf(fid,['*  cutting angle ' num2str(myAngle) 'deg ellipse gap= '  num2str( EllipseGap) '    \n']);
     fprintf(fid,['*  Ellipse gap' num2str(EllipseGap) 'nm  PadsInLineWidth ' num2str(PadsInLineWidth)  '  \n']);
     fprintf(fid,['*  ContactInLineWidth' num2str(ContactInLineWidth) 'nm  BaseInnerGap ' num2str(BaseInnerGap)  '  \n']);
     fprintf(fid,['*  BaseOutGap' num2str(BaseOutGap) 'nm  ContactGap ' num2str(ContactGap)  ' ContactGapPos ' num2str(ContactGapPos)  '  \n']);
     if  DoDecompose=='yes'
    fprintf(fid,['* sq decompos ratio' num2str(DecomposRatio) '  exp width ' num2str(DecomExpWidth) '  non width ' num2str(DecomposNonWidth) ' nm \n']);
    fprintf(fid,['* el decompos ratio' num2str(DecomposRatioEl) '  exp width ' num2str(DecomExpWidthEl) '  non width ' num2str(DecomposNonWidthEl) ' nm \n']);
    end 
    

  
    fprintf(fid,MyNameS1);
   %1
   if DoEllipseCenter=='yes';
     fprintf(fid,'* ellipse area  \n'); 
    a=InnerC1;MyLayer=1; PrintToJ01;
end

    %2
    fprintf(fid,'* ellipse upper Line bigger explosure \n');
    a=flipud(UpInLine1);MyLayer=2; PrintToJ01;
    %3
    fprintf(fid,'* ellipse Down Line snmaller explosure  \n');
    a=flipud(DownInLine1);MyLayer=3; PrintToJ01;
  %4
        fprintf(fid,'* base area  \n');
    a=BaseMain1;MyLayer=1; PrintToJ01;
    %5
            fprintf(fid,'* base upper line bigger intensity  \n');
    a=BaseOutInLine1;MyLayer=2; PrintToJ01;
    %6
            fprintf(fid,'*  base lower line smaller intensity  \n');
    a=BaseInnerInLine1;MyLayer=3; PrintToJ01;
        %7
    fprintf(fid,'* small connecting pad area  \n');
    a=BaseContactArea1;MyLayer=1; PrintToJ01;
    
        %8
   fprintf(fid,'* small connecting pad  Line  \n');
    a=BaseContactConLine1;MyLayer=2; PrintToJ01;
    

    

    %9
   fprintf(fid,'* BasePad Inline  \n');
    a=BasePadLine1;MyLayer=2; PrintToJ01;
  
    % 10 
       fprintf(fid,'* BasePad area  \n');
    a=BasePadArea1;MyLayer=1; PrintToJ01;
    

    fprintf(fid,'EF');
    fclose(fid);
    
       fid = fopen(myFileName2,'w');
%       MySizes=findObjectSizes(BaseMain1);  %not all
%      PrintSizesToFile;
     fprintf(fid,['*contact to Shottky transistor of size' num2str(el_sizeNano) 'nm \n']);
     fprintf(fid,['* used positive resist and it is after' myFileName2 'nm \n']);     
     fprintf(fid,['*metal contact ' num2str(el_sizeNano-metal_gap) ' nm ratio ' num2str(el_ratio) ' \n']);
          if  DoDecompose=='yes'
    fprintf(fid,['* sq decompos ratio' num2str(DecomposRatio) '  exp width ' num2str(DecomExpWidth) '  non width ' num2str(DecomposNonWidth) ' nm \n']);
    fprintf(fid,['* el decompos ratio' num2str(DecomposRatioEl) '  exp width ' num2str(DecomExpWidthEl) '  non width ' num2str(DecomposNonWidthEl) ' nm \n']);
    end 
%         fprintf(fid,['*metal gap ' num2str(base_gap) ' to nanomagnet ' num2str(real_gap) ' \n']);

    fprintf(fid,MyNameS2);
            
   
    %%%%%%
if ContactEllipseCenter=='yes'
    fprintf(fid,'* ellipse area   \n');
    a=AreaMetal1;MyLayer=1; PrintToJ01;
end
     fprintf(fid,'* ellipse  inline  \n');
     a=InLineMetal1;MyLayer=2; PrintToJ01;
    
    
        fprintf(fid,'* base area  \n');
    a=UpBaseContactAreaB2;MyLayer=1; PrintToJ01; 
    a=UpBaseContactAreaS2;MyLayer=1; PrintToJ01; 
            fprintf(fid,'* pad to base area \n');
    a=flipud(UpBasePadArea2);MyLayer=1; PrintToJ01; 
        fprintf(fid,'* base line  \n');
    a=UpBaseContactLine2;MyLayer=2; PrintToJ01; 
            fprintf(fid,'* pad to base line  \n');
    a=flipud(UpBasePadLine2);MyLayer=2; PrintToJ01; 

    
    fprintf(fid,'EF');
    fclose(fid); 
     
     
     
     
     
     return
    
     

     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
    
